#' @title Constants
#' @description Constants required for calculations.
#' @format
#' GSC: solar constant (0.0820 [MJ/(m2 min)]) \cr \cr
#' sigma: Stefan-Boltzmann constant (4.903 10^-9 [MJ/(K4 m2 day)]) \cr \cr
#' a1: constant lapse rate moist air (0.0065 [K/m]) (e.g. in \code{\link{estP}}) \cr \cr
#' R: specific gas constant (287 [J/(kg K)]) (e.g. in \code{\link{estP}}) \cr \cr
#' g: gravitational acceleration (9.807 [m/s2]) (e.g. in \code{\link{estP}}) \cr \cr
#' eps: ratio molecular weight of water vapour/dry air (0.622) (e.g. in \code{\link{psyc_cons}}) \cr \cr
#' lambda: latent heat of vaporization (2.45 [MJ/kg]) (e.g. in \code{\link{psyc_cons}}) \cr \cr
#' cp: specific heat at constant pressure (1.013 10-3 [MJ/(kg degreeC)])  (e.g. in \code{\link{psyc_cons}}) \cr \cr
#' @export
constDefaults <- list(GSC    = 0.0820,
                      sigma  = 4.903*10^-9,
                      eps    = 0.622,
                      lambda = 2.45,
                      cp     = 1.013*10^-3,
                      a1     = 0.0065,
                      R      = 287,
                      g      = 9.807)
