\name{get_mesh_info_obs}
\alias{get_mesh_info_obs}
\title{Get information about a list of mesh objects}
\description{Get key information about a list of mesh objects. This includes their respective number of vertices and triangles as well as their volume and centroid.}
\usage{
get_mesh_info_obs(x)
}
\arguments{
  \item{x}{\code{list} of mesh objects with a structure as generated by \code{\link[MeshAgreement]{read_mesh_obs}}.}
}
\details{Use \code{\link[MeshAgreement]{get_mesh_info_one}} for getting the information about a single mesh object. Use \code{\link[MeshAgreement]{get_mesh_info}} for getting the information about a list of observer/mesh objects.}
\value{
\code{data.frame} with these variables
\item{name}{Name of the mesh.}
\item{n_verts}{Number of vertices.}
\item{n_faces}{Number of faces.}
\item{volume}{Mesh volume.}
\item{ctr_x}{Centroid x-coordinate.}
\item{ctr_y}{Centroid y-coordinate.}
\item{ctr_z}{Centroid z-coordinate.}
}
\seealso{
\code{\link[MeshAgreement]{read_mesh_obs}},
\code{\link[MeshAgreement]{get_mesh_info_one}},
\code{\link[MeshAgreement]{get_mesh_info}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
Obs01  <- heartL[["Obs01"]]
get_mesh_info_obs(Obs01)
}
