% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVLasoelascox.R
\name{CVLasoelacox}
\alias{CVLasoelacox}
\title{Cross Validations for Lasso Elastic Net Survival predictive models and Classification}
\usage{
CVLasoelacox(Survival, Censor, Mdata, Prognostic, Quantile = 0.5,
  Metlist = NULL, Standardize = TRUE, Reduce = TRUE, Select = 15,
  Alpha = 1, Fold = 4, Ncv = 10, nlambda = 100)
}
\arguments{
\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Censor}{A vector of censoring indicator}

\item{Mdata}{A large or small metabolic profile matrix. A matrix with metabolic profiles where the number of rows should be equal to the number of metabolites and number of columns should be equal to number of patients.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Quantile}{The cut off value for the classifier, default is the median cutoff}

\item{Metlist}{A list of metabolites to be considered in the model usually smaller than the metabolites in the Mdata . Default is to use all metabolites available and it is advisable to be greater than 17.}

\item{Standardize}{A Logical flag for the standardization of the metabolite matrix, prior to fitting the model sequence. The coefficients are always returned on the original scale. Default is standardize=TRUE.}

\item{Reduce}{A boolean parameter indicating if the metabolic profile matrix should be reduced, default is TRUE and larger metabolic profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of metabolites (default is 15) to be selected from supervised PCA. This is valid only if the argument Reduce=TRUE}

\item{Alpha}{The mixing parameter for glmnet (see \code{\link[glmnet]{glmnet}}). The range is 0<= Alpha <= 1. The Default is 1}

\item{Fold}{number of folds to be used for the cross validation. Its value ranges between 3 and the numbe rof subjects in the dataset}

\item{Ncv}{Number of validations to be carried out. The default is 25.}

\item{nlambda}{The number of lambda values - default is 100 as in glmnet.}
}
\value{
A object of class \code{\link[MetabolicSurv]{cvle}} is returned with the following values
  \item{Coef.mat}{A matrix of coefficients with rows equals to number of cross validations and columns equals to number of metabolites.}
  \item{Runtime}{A vector of runtime for each iteration measured in seconds.}
  \item{lambda}{A vector of estimated optimum lambda for each iterations.}
  \item{n}{A vector of the number of selected metabolites}
  \item{HRTrain}{A matrix of survival information for the training dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}
  \item{HRTest}{A matrix of survival information for the test dataset. It has three columns representing the estimated HR, the 95\% lower confidence interval and the 95\% upper confidence interval.}
  \item{pld}{A vector of partial likelihood deviance at each cross validations.}
  \item{Met.mat}{A matrix with 0 and 1. Number of rows equals to number of iterations and number of columns equals to number of metabolites. 1 indicates that the particular metabolite was selected or had nonzero coefficient and otherwise it is zero.}
 \item{Mdata}{The Metabolite data matrix that was used for the analysis either same as Mdata or a reduced version.}
}
\description{
The function does cross validation for Lasso, Elastic net and Ridge regressions models before the survial analysis and classification. The survival analysis is based on the selected metabolites in the presence or absene of prognostic factors.
}
\details{
The function performs the cross validations for Lasso, Elastic net and Ridge regressions models for Cox proportional hazard model. Metabolites are selected at each iteration and then use for the classifier. Which implies that predictive metabolites signature is varied from one cross validation to the other depending on selection. The underline idea is to investigate the Hazard Ratio for the train and test data based on the optimal lambda selected for the non-zero shrinkage coefficients, the nonzero selected metabolites will thus be used in the survival analysis and in calculation of the risk scores for each sets of data.
}
\examples{
\donttest{
## FIRSTLY SIMULATING A METABOLIC SURVIVAL DATA
Data = MSData(nPatients = 100, nMet = 150, Prop = 0.5)

## USING THE FUNCTION
Results = CVLasoelacox(Survival = Data$Survival,Censor = Data$Censor,
Mdata = t(Data$Mdata),Prognostic = Data$Prognostic, Quantile = 0.5,
Metlist = NULL,Standardize = TRUE, Reduce=FALSE, Select=15,
Alpha = 1,Fold = 4,Ncv = 10,nlambda = 100)

## NUMBER OF SELECTED METABOLITES PER CV
Results@n

## GET THE MATRIX OF COEFFICIENTS
Results@Coef.mat

## SURVIVAL INFORMATION OF THE TRAIN DATASET
Results@HRTrain

## SURVIVAL INFORMATION OF THE TEST DATASET
Results@HRTest
}
}
\seealso{
\code{\link[survival]{coxph}},
\code{\link[MetabolicSurv]{EstimateHR}}, \code{\link[glmnet]{glmnet}}, \code{\link[MetabolicSurv]{Lasoelacox}}
}
\author{
Olajumoke Evangelina Owokotomo, \email{olajumoke.owokotomo@uhasselt.be}

Ziv Shkedy
}
