% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryStatistics.R
\name{get_meanMeth_islands}
\alias{get_meanMeth_islands}
\title{Compute the Mean Methylation of CpG Islands}
\usage{
get_meanMeth_islands(index_islands, data)
}
\arguments{
\item{index_islands}{A numeric vector specifying the indices of genomic structures corresponding to islands.}

\item{data}{A list containing methylation states at tree tips for each genomic structure
(e.g., island/non-island). The data should be structured as \code{data[[tip]][[structure]]},
where each tip has the same number of structures, and each structure has the same number of sites across tips.}
}
\value{
A list where each element corresponds to a tree tip and contains a numeric vector
representing the mean methylation levels for the indexed CpG islands.
}
\description{
This function calculates the mean methylation level for CpG islands across all tree tips.
}
\examples{
# Example data setup

data <- list(
  # Tip 1
  list(rep(1,10), rep(0,5), rep(1,8)),
  # Tip 2
  list(rep(1,10), rep(0.5,5), rep(0,8))
)

index_islands <- c(1,3)

get_meanMeth_islands(index_islands, data)

}
