% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiSummarize.R
\name{MiSummarize}
\alias{MiSummarize}
\title{Microarray data summarization}
\usage{
MiSummarize(Matrix, sep, method = "median")
}
\arguments{
\item{Matrix}{numeric matrix of intensities data where each row corresponds to a probe (gene, transcript),
and each column correspondes to a specimen (patient).
Row names of \code{Matrix} should contain probe IDs that consist of three terms:
gene name - transcript name - probe name.}

\item{sep}{a character string to separate the terms in probe IDs.}

\item{method}{character string specifying summarization method. Possible values are "median" and "mean".}
}
\value{
gene/transcript expression matrix with median/mean of expression intensities for each gene/transcript.
}
\description{
Counts median of intensities for multiple probes that target one gene/transcript.
}
\details{
This function is used for summarizing expression intensities data when multiple probes target
one gene/transcript. Row names of \code{Matrix} should contain probe IDs that consist of 3 terms:
"Gene name - sep - transcript name - sep - probe name" (for example, "AGTR2.ALL" - for gene, only one probe;
"AGTR2.NM_000686.z1" - 1st probe to AGTR2 NM_000686 mRNA transcript).
}
\examples{
data("IMexpression") # load data
# See 5 zonds to AGTR2.NM_000686
IMexpression [1:10, 1:5]
SumMatrix<-MiSummarize(IMexpression, sep=".")
# now there is median expression for AGTR2.NM_000686
SumMatrix[ 1:10, 1:5]

}
\author{
Elena N. Filatova
}
