% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{MetaboWAS}
\alias{MetaboWAS}
\title{MetaboWAS}
\usage{
MetaboWAS(met, pheno, test_variable, covariates, img = TRUE, adj_method = "BH")
}
\arguments{
\item{met}{numeric data.frame with the metabolomics features}

\item{pheno}{data.frame containing the phenotype of interest}

\item{test_variable}{string vector with the name of the phenotype of interest}

\item{covariates}{string vector with the name of the variables to be added as a covariate}

\item{img}{logical indicating if the function should plot a Manhattan plot}

\item{adj_method}{multiple testing correction method}
}
\value{
res= the results of the MetaboWAS, manhplot= the Manhattan plot made with plotly, N_hits= the number of significant hits
}
\description{
Function to calculate a Metabolome Wide Association study
}
\details{
This is a function to compute linear associations individually for each variable in the first data.frame
with the test variable and corrected for the selected covariates.
This function to computes linear regression modelindividually for each variable in the first data.frame
with the test variable and adjusted for potential confounders.
False Discovery Rate (FDR) is applied to account for multiple testing correction.
The user has the faculty to select the test variable and the potential covariates within the pool of variables in the phenotypic file input.
The results of the associations are reported in a Manhattan plot

The p-value of the association is then corrected using Benjamini Hochberg.
Finally we use plotly to plot a Manhattan Plot, which reports on the x-axis the list of metabolites reported in the Nightingale Health,
divided in groups, and on the y-axis the -log (adjusted p-value).
}
\examples{
require(MiMIR)
require(plotly)
require(ggplot2)

#' #load the dataset
metabolic_measures <- synthetic_metabolic_dataset
phenotypes <- synthetic_phenotypic_dataset

#Computing a MetaboWAS for age corrected by sex
MetaboWAS(met=metabolic_measures, pheno=phenotypes, test_variable="age", covariates= "sex")

}
\references{
This method is also described and used in:
Bizzarri,D. et al. (2022) 1H-NMR metabolomics-based surrogates to impute common clinical risk factors and endpoints. EBioMedicine, 75, 103764, doi: 10.1016/j.ebiom.2021.103764
}
