% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{kapmeier_scores}
\alias{kapmeier_scores}
\title{kapmeier_scores}
\usage{
kapmeier_scores(predictors, pheno, score, Eventname = "Event")
}
\arguments{
\item{predictors}{The data.frame containing the predictors}

\item{pheno}{The data.frame containing the phenotypes}

\item{score}{a character string indicating which predictor to use}

\item{Eventname}{a character string with the name of the event to print on the plot}
}
\value{
plotly with a Kaplan Meier comparing first and last tertile of a metabolic score
}
\description{
#' Function that creates a Kaplan Meier comparing first and last tertile of a metabolic score
}
\examples{
require(MiMIR)
require(plotly)
require(survminer)
require(ggfortify)
require(ggplot2)

#load the dataset
metabolic_measures <- synthetic_metabolic_dataset
phenotypes <- synthetic_phenotypic_dataset

#Compute the mortality score
mortScore<-comp.mort_score(metabolic_measures,quiet=TRUE)

#Plot a Kaplan Meier
kapmeier_scores(predictors=mortScore, pheno=phenotypes, score="mortScore")

}
