% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNA_expression_preprocessing.R
\name{miRNA_expressionPreprocessing}
\alias{miRNA_expressionPreprocessing}
\title{Pre-processing of datasets.}
\usage{
miRNA_expressionPreprocessing(inputDataset, multipletSize)
}
\arguments{
\item{inputDataset}{Dataset (data frame) to be pre-processed. The data frame must contain the columns 'Subject', 'miRNA', 'Value' and possibly 'Class'. Any other column is ignored, and any missing column forbids execution.}

\item{multipletSize}{Size of the multiplets to be considered. Any multiplet of different size is ignored.}
}
\value{
A pre-processed data frame, containing the columns 'Subject', 'miRNA', 'Mean', 'StdDev', 'SampleSize', and possibly 'Class'.
}
\description{
This function carries out the pre-processing required by the other functions of the miRNA-QC-and-Diagnosis package.
}
\examples{
requiredFile = paste(system.file(package="MiRNAQCD"), "/extdata/dataset_alpha.dat", sep='')
myDataFrame <- read.table(file=requiredFile, header=TRUE)
myPreprocessedDataFrame <- miRNA_expressionPreprocessing(myDataFrame, 3)

}
