% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{strata_to_residency_counts}
\alias{strata_to_residency_counts}
\title{Helper function for lumped population strata (counts)}
\usage{
strata_to_residency_counts(H_counts)
}
\arguments{
\item{H_counts}{a matrix of population counts}
}
\value{
a \link{list} with three elements:
\itemize{
\item \code{J}: the residency matrix mapping elements in \code{H} to patches
\item \code{H}: the overall population distribution over strata and patches
}
}
\description{
If input is given as a matrix of population counts per strata (columns)
and patch (rows), this function calculates the residency matrix and
population size for the overall stratification of both residency and strata.
}
\examples{
# taken from package tests
J <- matrix(
   c(0.3, 0.5, 0.2,
   0.1, 0.6, 0.3), nrow = 3, ncol = 2, byrow = FALSE
)
H <- c(50, 60)
H_overall <- J \%*\% diag(H)
residency <- strata_to_residency_proportion(H_strata = H, J_strata = J)
}
