% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{add_methods}
\alias{add_methods}
\title{Microsoft 365 object accessor methods}
\description{
Methods for the \code{\link[AzureGraph:ms_graph]{AzureGraph::ms_graph}}, \code{\link[AzureGraph:az_user]{AzureGraph::az_user}} and \code{\link[AzureGraph:az_group]{AzureGraph::az_group}} classes.
}
\section{Usage}{
\preformatted{## R6 method for class 'ms_graph'
get_drive(drive_id)

## R6 method for class 'az_user'
get_drive(drive_id = NULL)

## R6 method for class 'az_group'
get_drive(drive_id = NULL)

## R6 method for class 'ms_graph'
get_sharepoint_site(site_url = NULL, site_id = NULL)

## R6 method for class 'az_group'
get_sharepoint_site()

## R6 method for class 'ms_graph'
get_team(team_id = NULL)

## R6 method for class 'az_group'
get_team()

## R6 method for class 'az_user'
list_drives()

## R6 method for class 'az_group'
list_drives()

## R6 method for class 'az_user'
list_sharepoint_sites(filter = NULL)

## R6 method for class 'az_user'
list_teams(filter = NULL)
}
}

\section{Arguments}{

\itemize{
\item \code{drive_id}: For \code{get_drive}, the ID of the drive or shared document library. For the \code{az_user} and \code{az_group} methods, if this is NULL the default drive/document library is returned.
\item \code{site_url},\code{site_id}: For \code{ms_graph$get_sharepoint_site()}, the URL and ID of the site. Provide one or the other, but not both.
\item \code{team_name},\code{team_id}: For \code{az_user$get_team()}, the name and ID of the site. Provide one or the other, but not both. For \code{ms_graph$get_team}, you must provide the team ID.
\item \code{filter}: For \code{az_user$list_sharepoint_sites()} and \code{az_user$list_teams()}, an optional OData expression to filter the list.
}
}

\section{Details}{

\code{get_sharepoint_site} retrieves a SharePoint site object. The method for the top-level Graph client class requires that you provide either the site URL or ID. The method for the \code{az_group} class will retrieve the site associated with that group, if applicable.

\code{get_drive} retrieves a OneDrive or shared document library, and \code{list_drives} retrieves all such drives/libraries that the user or group has access to. Whether these are personal or business drives depends on the tenant that was specified in \code{AzureGraph::get_graph_login()}/\code{create_graph_login()}: if this was "consumers" or "9188040d-6c67-4c5b-b112-36a304b66dad" (the equivalent GUID), it will be the personal OneDrive. See the examples below.

\code{get_team} retrieves a team. The method for the Graph client class requires the team ID. The method for the \code{az_user} class requires either the team name or ID. The method for the \code{az_group} class retrieves the team associated with the group, if it exists.

Note that Teams, SharePoint and OneDrive for Business require a Microsoft 365 Business license, and are available for organisational tenants only.
}

\section{Value}{

For \code{get_sharepoint_site}, an object of class \code{ms_site}.

For \code{get_drive}, an object of class \code{ms_drive}. For \code{list_drives}, a list of \code{ms_drive} objects.

For \code{get_team}, an object of class \code{ms_team}. For \code{list_teams}, a list of \code{ms_team} objects.
}

\examples{
\dontrun{

# 'consumers' tenant -> personal OneDrive for a user
gr <- AzureGraph::get_graph_login("consumers", app="myapp")
me <- gr$get_user()
me$get_drive()

# organisational tenant -> business OneDrive for a user
gr2 <- AzureGraph::get_graph_login("mycompany", app="myapp")
myuser <- gr2$get_user("username@mycompany.onmicrosoft.com")
myuser$get_drive()

# get a site/drive directly from a URL/ID
gr2$get_sharepoint_site("My site")
gr2$get_drive("drive-id")

# site/drive(s) for a group
grp <- gr2$get_group("group-id")
grp$get_sharepoint_site()
grp$list_drives()
grp$get_drive()

}
}
\seealso{
\code{\link{ms_site}}, \code{\link{ms_drive}}, \code{\link{az_user}}, \code{\link{az_group}}
}
