% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client_deprecated.R
\name{personal_onedrive}
\alias{personal_onedrive}
\alias{client-deprecated}
\alias{business_onedrive}
\alias{sharepoint_site}
\title{Deprecated client functions}
\usage{
personal_onedrive(
  app = .microsoft365r_app_id,
  scopes = c("Files.ReadWrite.All", "User.Read"),
  ...
)

business_onedrive(
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)

sharepoint_site(
  site_url = NULL,
  site_id = NULL,
  tenant = Sys.getenv("CLIMICROSOFT365_TENANT", "common"),
  app = Sys.getenv("CLIMICROSOFT365_AADAPPID"),
  scopes = ".default",
  ...
)
}
\arguments{
\item{app}{A custom app registration ID to use for authentication. For \code{personal_onedrive}, the default is to use Microsoft365R's internal app ID. For \code{business_onedrive} and \code{sharepoint_site}, see below.}

\item{scopes}{The Microsoft Graph scopes (permissions) to obtain.}

\item{...}{Optional arguments to be passed to \code{AzureGraph::create_graph_login}.}

\item{tenant}{For \code{business_onedrive} and \code{sharepoint_site}, the name of your Azure Active Directory (AAD) tenant. If not supplied, use the value of the \code{CLIMICROSOFT365_TENANT} environment variable, or "common" if that is unset.}

\item{site_url, site_id}{For \code{sharepoint_site}, the web URL and ID of the SharePoint site to retrieve. Supply one or the other, but not both.}
}
\description{
Deprecated client functions
}
\details{
These functions have been replaced by \code{\link{get_personal_onedrive}}, \code{\link{get_business_onedrive}} and \code{\link{get_sharepoint_site}}. They will be removed in a later version of the package.
}
