# MigConnectivity [![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1002228.svg)](https://zenodo.org/record/1002228#.Wm_Oh3xG1EY)    
The MigConnectivity package quantifies the pattern and strength of migratory connectivity for migratory animals

The pattern of migratory connectivity can be expressed as migratory transition probabilities between sites or regions in any two phases of the annual cycle.

MC is a standardized metric to quantify migratory connectivity strength between two phases 
of the annual cycle. MC is independent of data type and accounts for the relative abundance of populations distributed across a seasonal range. 

See the [vignettes](https://smbc-nzp.github.io/MigConnectivity/MigConnectivity.html) for details and examples.

## Installation

If you will (or might) use Markov chain Monte Carlo (MCMC) estimation in 
MigConnectivity, you should first install the program JAGS on your computer, 
available at https://mcmc-jags.sourceforge.net. Then:

```r
install.packages("devtools")
devtools::install_github("SMBC-NZP/MigConnectivity")
```

to install the vignette on your machine along with the package use the following code.   
*Note* it takes a bit longer to download the package if `build_vignettes = TRUE`

```r
devtools::install_github("SMBC-NZP/MigConnectivity", build_vignettes = TRUE)
```

### Issues

Find a bug?  Want to request an enhancement? Check out our [issues](https://github.com/SMBC-NZP/MigConnectivity/issues) page!
