% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{upset_pq}
\alias{upset_pq}
\title{Make upset plot for phyloseq object.}
\usage{
upset_pq(
  physeq,
  fact,
  taxa_fill = NULL,
  min_nb_seq = 0,
  na_remove = TRUE,
  numeric_fonction = sum,
  rarefy_after_merging = FALSE,
  ...
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{(required): Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{taxa_fill}{(default NULL) fill the ASV upset using a column in
\code{tax_table} slot.}

\item{min_nb_seq}{minimum number of sequences by OTUs by
samples to take into count this OTUs in this sample. For example,
if min_nb_seq=2,each value of 2 or less in the OTU table
will not count in the venn diagram}

\item{na_remove}{: if TRUE (the default), NA values in fact are removed
if FALSE, NA values are set to "NA"}

\item{numeric_fonction}{(default : sum) the function for numeric vector
useful only for complex plot (see examples)}

\item{rarefy_after_merging}{Rarefy each sample after merging by the
modalities of \code{fact} parameter}

\item{...}{other arguments passed on to the \code{\link[ComplexUpset:upset]{ComplexUpset::upset()}}}
}
\value{
A \code{\link{ggplot}}2 plot
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Alternative to venn plot.
}
\examples{

upset_pq(data_fungi_mini,
  fact = "Height", width_ratio = 0.2,
  taxa_fill = "Class"
)
\donttest{
upset_pq(data_fungi_mini, fact = "Height", min_nb_seq = 1000)
upset_pq(data_fungi_mini, fact = "Height", na_remove = FALSE)

upset_pq(data_fungi_mini, fact = "Time", width_ratio = 0.2, rarefy_after_merging = TRUE)

upset_pq(
  data_fungi_mini,
  fact = "Time",
  width_ratio = 0.2,
  annotations = list(
    "Sequences per ASV \n (log10)" = (
      ggplot(mapping = aes(y = log10(Abundance)))
      +
        geom_jitter(aes(
          color =
            Abundance
        ), na.rm = TRUE)
        +
        geom_violin(alpha = 0.5, na.rm = TRUE) +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    ),
    "ASV per phylum" = (
      ggplot(mapping = aes(fill = Phylum))
      +
        geom_bar() +
        ylab("ASV per phylum") +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    )
  )
)


upset_pq(
  data_fungi_mini,
  fact = "Time",
  width_ratio = 0.2,
  numeric_fonction = mean,
  annotations = list(
    "Sequences per ASV \n (log10)" = (
      ggplot(mapping = aes(y = log10(Abundance)))
      +
        geom_jitter(aes(
          color =
            Abundance
        ), na.rm = TRUE)
        +
        geom_violin(alpha = 0.5, na.rm = TRUE) +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    ),
    "ASV per phylum" = (
      ggplot(mapping = aes(fill = Phylum))
      +
        geom_bar() +
        ylab("ASV per phylum") +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    )
  )
)


upset_pq(
  subset_taxa(data_fungi_mini, Phylum == "Basidiomycota"),
  fact = "Time",
  width_ratio = 0.2,
  base_annotations = list(),
  annotations = list(
    "Sequences per ASV \n (log10)" = (
      ggplot(mapping = aes(y = log10(Abundance)))
      +
        geom_jitter(aes(
          color =
            Abundance
        ), na.rm = TRUE)
        +
        geom_violin(alpha = 0.5, na.rm = TRUE) +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    ),
    "ASV per phylum" = (
      ggplot(mapping = aes(fill = Class))
      +
        geom_bar() +
        ylab("ASV per Class") +
        theme(legend.key.size = unit(0.2, "cm")) +
        theme(axis.text = element_text(size = 12))
    )
  )
)

data_fungi2 <- data_fungi_mini
data_fungi2@sam_data[["Time_0"]] <- data_fungi2@sam_data$Time == 0
data_fungi2@sam_data[["Height__Time_0"]] <-
  paste0(data_fungi2@sam_data[["Height"]], "__", data_fungi2@sam_data[["Time_0"]])
data_fungi2@sam_data[["Height__Time_0"]][grepl("NA", data_fungi2@sam_data[["Height__Time_0"]])] <-
  NA
upset_pq(data_fungi2, fact = "Height__Time_0", width_ratio = 0.2, min_size = 2)
}
}
\seealso{
\code{\link[=ggvenn_pq]{ggvenn_pq()}}
}
\author{
Adrien Taudière
}
