% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dada_phyloseq.R
\name{mumu_pq}
\alias{mumu_pq}
\title{MUMU reclustering of class \code{physeq}}
\usage{
mumu_pq(
  physeq,
  nproc = 1,
  id = 0.84,
  vsearchpath = "vsearch",
  mumupath = "mumu",
  verbose = FALSE,
  clean_pq = TRUE,
  keep_temporary_files = FALSE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{nproc}{(default 1)
Set to number of cpus/processors to use for the clustering}

\item{id}{(default: 0.84) id for --usearch_global.}

\item{vsearchpath}{(default: vsearch) path to vsearch.}

\item{mumupath}{path to mumu. See \href{https://github.com/frederic-mahe/mumu}{mumu}
for installation instruction}

\item{verbose}{(logical) if true, print some additional messages.}

\item{clean_pq}{(logical) if true, empty samples and empty ASV are discarded
before clustering.}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary files}
}
\value{
a list of for object
\itemize{
\item "new_physeq": The new phyloseq object (class physeq)
\item "mumu_results": The log file of the mumu software. Run \verb{man mumu} into
bash to obtain details about columns' signification.
}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-experimental-orange" alt="lifecycle-experimental"></a>
}}


See https://www.nature.com/articles/s41467-017-01312-x for more information
on the original method LULU. This is a wrapper of
\href{https://github.com/frederic-mahe/mumu}{mumu} a C++ re-implementation
of LULU by Frédéric Mahé
}
\details{
This function is mainly a wrapper of the work of others.
Please cite \href{https://github.com/frederic-mahe/mumu/blob/main/CITATION.cff}{mumu} and
\href{https://www.nature.com/articles/s41467-017-01312-x}{lulu} if you use this function
for your work.
}
\examples{
\dontshow{if (MiscMetabar::is_mumu_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
mumu_pq(data_fungi_sp_known)
}
\dontshow{\}) # examplesIf}
}
\references{
\itemize{
\item MUMU: \url{https://github.com/frederic-mahe/mumu}
\item VSEARCH can be downloaded from
\url{https://github.com/torognes/vsearch}.
}
}
\author{
Frédéric Mahé
& Adrien Taudière \email{adrien.taudiere@zaclys.net}
}
