\name{DelLessData}
\alias{DelLessData}
\title{Removes groups with identical missing data patterns having at most a given number of cases
}
\description{Removes groups of missing data patterns with number of cases
less than or equal to a specified value (ncases).
}
\usage{
DelLessData(data, ncases = 0)
}
\arguments{
 \item{data}{
 A matrix consisting of at least two columns.
 Values must be numerical with missing data indicated by NA.
}
 \item{ncases}{
 Missing data pattern groups with ncases
 number of cases or less will be removed from the data set
}
}
\value{
\item{data }{A matrix of reaaranged data, according to missing data patterns, with missing data patterns having less than ncases number of cases removed.}
\item{patused }{A matrix indicating the missing data patterns in the data set; observed variable(s) are indiated by  1's' and missing variables are indicated by NA's.}
\item{patcnt}{A vector consisting of the number of cases corresponding to each pattern in patused.}
\item{spatcnt}{Cumulative sum of elements of patcnt.}
\item{g}{Number of missing data patterns.}
\item{caseorder}{A mapping of case number indices from output data (rearranged data) to input data.}
\item{removedcases }{The index of cases that were removed from the original data set}
}
\author{
Mortaza Jamshidian, Siavash Jalal, and Camden Jansen
}
\examples{
set.seed <- 50
n <- 200
p <- 4
pctmiss <- 0.2
y <- matrix(rnorm(n * p),nrow = n)
missing <- matrix(runif(n * p), nrow = n) < pctmiss
y[missing] <- NA
out <- DelLessData(data=y, ncases = 4)
dim(y)
dim(out$data)
}
