% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ClusterModelNames.R
\name{clusterKernelNames}
\alias{clusterKernelNames}
\alias{clusterValidKernelNames}
\title{Create a vector of Kernel mixture model names.}
\usage{
clusterKernelNames(prop = "all", sdBetweenCluster = "all")

clusterValidKernelNames(names)
}
\arguments{
\item{prop}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{sdBetweenCluster}{A character string equal to "equal", "free" or "all". Default is "all".}

\item{names}{a vector of character}
}
\value{
A vector of character with the model names.
}
\description{
In a diagonal Kernel mixture model, we can assume that
\enumerate{
 \item {The proportions can be equal or free.}
 \item {The standard deviations can be equal or free for all the clusters.}
}
This give rise to four models.

check if a vector of kernel mixture model name is correct.
}
\details{
The model names are summarized in the following array:
\tabular{lll}{
 Model Name           \tab Proportions \tab s.d. between clusters \cr
 kernelGaussian_p_sk  \tab Equal       \tab Free                  \cr
 kernelGaussian_p_s   \tab Equal       \tab Equal                 \cr
 kernelGaussian_pk_sk \tab Free        \tab Free                  \cr
 kernelGaussian_pk_s  \tab Free        \tab Equal                 \cr
}
}
\examples{
clusterKernelNames()
## same as c("kernelGaussian_p_sk", "kernelGaussian_pk_sk")
clusterKernelNames(prop="all", sdBetweenCluster= "free")
}

