% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterAlgo.R, R/ClusterAlgoPredict.R,
%   R/ClusterInit.R, R/ClusterStrategy.R, R/IClusterModel.R,
%   R/ClusterCategorical.R, R/ClusterDiagGaussian.R, R/ClusterGamma.R,
%   R/ClusterMixedData.R, R/ClusterPoisson.R, R/IClusterPredict.R,
%   R/ClusterPredict.R, R/LearnAlgo.R, R/kmm.R, R/kmmMixedData.R
\docType{methods}
\name{initialize,ClusterAlgo-method}
\alias{initialize,ClusterAlgo-method}
\alias{initialize,ClusterAlgoPredict-method}
\alias{initialize,ClusterInit-method}
\alias{initialize,ClusterStrategy-method}
\alias{initialize,IClusterComponent-method}
\alias{initialize,IClusterModel-method}
\alias{initialize,ClusterCategoricalComponent-method}
\alias{initialize,ClusterCategorical-method}
\alias{initialize,ClusterDiagGaussianComponent-method}
\alias{initialize,ClusterDiagGaussian-method}
\alias{initialize,ClusterGammaComponent-method}
\alias{initialize,ClusterGamma-method}
\alias{initialize,ClusterMixedDataModel-method}
\alias{initialize,ClusterPoissonComponent-method}
\alias{initialize,ClusterPoisson-method}
\alias{initialize,IClusterPredict-method}
\alias{initialize,ClusterPredict-method}
\alias{initialize,ClusterPredictMixedData-method}
\alias{initialize,LearnAlgo-method}
\alias{initialize,KmmComponent-method}
\alias{initialize,KmmModel-method}
\alias{initialize,KmmMixedDataModel-method}
\title{Initialize an instance of a MixAll S4 class.}
\usage{
\S4method{initialize}{ClusterAlgo}(.Object, algo, nbIteration, epsilon)

\S4method{initialize}{ClusterAlgoPredict}(.Object, algo, nbIterBurn,
  nbIterLong, epsilon)

\S4method{initialize}{ClusterInit}(.Object, method = "class",
  nbInit = 5, algo = clusterAlgo("EM", 20, 0))

\S4method{initialize}{ClusterStrategy}(.Object, nbTry, nbShortRun,
  initMethod, shortAlgo, longAlgo)

\S4method{initialize}{IClusterComponent}(.Object, data, modelName)

\S4method{initialize}{IClusterModel}(.Object, nbSample, nbCluster)

\S4method{initialize}{ClusterCategoricalComponent}(.Object,
  data = matrix(nrow = 0, ncol = 0), nbCluster = 2,
  modelName = "categorical_pk_pjk")

\S4method{initialize}{ClusterCategorical}(.Object, data = matrix(nrow =
  0, ncol = 0), nbCluster = 2, modelName = "categorical_pk_pjk")

\S4method{initialize}{ClusterDiagGaussianComponent}(.Object,
  data = matrix(nrow = 0, ncol = 0), nbCluster = 2,
  modelName = "gaussian_pk_sjk")

\S4method{initialize}{ClusterDiagGaussian}(.Object, data = matrix(nrow =
  0, ncol = 0), nbCluster = 2, modelName = "gaussian_pk_sjk")

\S4method{initialize}{ClusterGammaComponent}(.Object, data = matrix(nrow
  = 0, ncol = 0), nbCluster = 2, modelName = "gamma_pk_ajk_bjk")

\S4method{initialize}{ClusterGamma}(.Object, data = matrix(nrow = 0, ncol
  = 0), nbCluster = 2, modelName = "gamma_pk_ajk_bjk")

\S4method{initialize}{ClusterMixedDataModel}(.Object, lcomponent,
  nbCluster = 2)

\S4method{initialize}{ClusterPoissonComponent}(.Object,
  data = matrix(nrow = 0, ncol = 0), nbCluster = 2,
  modelName = "poisson_pk_ljk")

\S4method{initialize}{ClusterPoisson}(.Object, data = matrix(nrow = 0,
  ncol = 0), nbCluster = 2, modelName = "poisson_pk_ljk")

\S4method{initialize}{IClusterPredict}(.Object, nbSample, model, algo)

\S4method{initialize}{ClusterPredict}(.Object, data, model,
  algo = clusterAlgoPredict())

\S4method{initialize}{ClusterPredictMixedData}(.Object, ldata, model,
  algo = clusterAlgoPredict())

\S4method{initialize}{LearnAlgo}(.Object, algo, nbIteration, epsilon)

\S4method{initialize}{KmmComponent}(.Object, data, dim = 10,
  nbCluster = 2, modelName = "kmm_pk_s", kernelName = "Gaussian",
  kernelParameters = c(1), kernelComputation = TRUE)

\S4method{initialize}{KmmModel}(.Object, data, nbCluster = 2,
  modelName = "kmm_pk_s", dim = 10, kernelName = "Gaussian",
  kernelParameters = c(1), kernelComputation = TRUE)

\S4method{initialize}{KmmMixedDataModel}(.Object, lcomponent,
  nbCluster = 2)
}
\description{
Initialization method of the [\code{\linkS4class{ClusterAlgo}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterAlgoPredict}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterInit}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterStrategy}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{IClusterComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{IClusterModel}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterCategoricalComponent}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterCategorical}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterDiagGaussianComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterDiagGaussian}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterGammaComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterGamma}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterMixedDataModel}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPoissonComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPoisson}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{IClusterPredict}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPredict}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{ClusterPredictMixedData}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{LearnAlgo}}] class.
Used internally in the `MixAll' package.

Initialization method of the [\code{\linkS4class{KmmComponent}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{KmmModel}}] class.
Used internally in the 'MixAll' package.

Initialization method of the [\code{\linkS4class{KmmMixedDataModel}}] class.
Used internally in the 'MixAll' package.
}
\keyword{internal}
