% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.admixture.R
\name{get.admixture}
\alias{get.admixture}
\title{Admixture Plot}
\usage{
get.admixture(
  population,
  geno = NULL,
  gen = NULL,
  database = NULL,
  cohorts = NULL,
  d = NULL,
  verbose = TRUE,
  plot = TRUE,
  sort = FALSE,
  sort.cutoff = 0.01
)
}
\arguments{
\item{population}{Population list}

\item{geno}{Manually provided genotype dataset to use instead of gen/database/cohorts}

\item{gen}{Quick-insert for database (vector of all generations to consider)}

\item{database}{Groups of individuals to consider}

\item{cohorts}{Quick-insert for database (vector of names of cohorts to consider)}

\item{d}{dimensions to consider in admixture plot (default: automatically estimate a reasonable number)}

\item{verbose}{Set to FALSE to not display any prints}

\item{plot}{Set to FALSE to not generate an admixture plot}

\item{sort}{Set to TRUE to sort individuals according to contributes from the first dimension}

\item{sort.cutoff}{Skip individuals with contributions under this threshold (and use next dimension instead)
data(ex_pop)
get.admixture(ex_pop, gen=4:6, d=2, sort=TRUE)}
}
\value{
Matrix with admixture proportion
}
\description{
Function to generate admixture plots
}
