% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_functions.R
\name{initializeBeta}
\alias{initializeBeta}
\title{Beta initialization}
\usage{
initializeBeta(dtm, init.beta, K, verbose = 0, control_lda_init = NULL)
}
\arguments{
\item{dtm}{An object of class \code{\link{DocumentTermMatrix}}}

\item{init.beta}{A string specifying the method, either \itemize{\item
'random': Initialization a la Blei et. al. with 1/V coefficient everywhere
+ a small uniform noise U[0, 1e-10] on every coefficients. \item 'lda':
Recommended. Uses the beta of LDA algorithm via a VEM algorithm, with an
initialization of 5 repeats of the gibbs sampling algorithm with 1000
burning iterations and 1000 iterations.  }}

\item{K}{The number of topics (dimension of the latent space).}

\item{verbose}{The verbosity level. Only prints a message at function
activation.}

\item{control_lda_init}{The control for \code{\link{LDA}}().
Only used when \code{init.beta} == 'lda' and initilialized to the default
\code{"LDA_VEMcontrol"} of the \code{\linkS4class{TopicModelcontrol}}
class.}
}
\value{
A KxV matrix with each row summing to 1.
}
\description{
Used in the \code{\link{mmpca_clust}}() function to initialize
  beta. It can be either "random" or "lda". Please not that the
  \code{\link{mmpca_clust}}() function also allow for a user given beta
  matrix. In this case, this function is not used.
}
\examples{
\donttest{
simu = simulate_BBC(N = 100, L = 100)
K = 4
beta = initializeBeta(simu$dtm.full, 'lda', K, verbose = 1)
}
}
