% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mmpca_clust.R
\name{mmpca_clust}
\alias{mmpca_clust}
\title{Greedy procedures for joint inference and clustering in MMPCA}
\usage{
mmpca_clust(
  dtm,
  Q,
  K,
  model = NULL,
  Yinit = "random",
  method = "BBCVEM",
  init.beta = "lda",
  keep = 1L,
  max.epochs = 10L,
  verbose = 1L,
  nruns = 1L,
  mc.cores = max(1, (detectCores() - 1))
)
}
\arguments{
\item{dtm}{an NxV \code{\link{DocumentTermMatrix}} with term-frequency
weighting.}

\item{Q}{The number of clusters}

\item{K}{The number of topics (latent space dimension)}

\item{model}{A given model in which to take the controls for the VE-steps in
the greedy procedure. If NULL, a model of class
\code{\linkS4class{mmpcaClust}} is created with default controls (see
\code{\linkS4class{mmpcaClustcontrol}} class for more details).}

\item{Yinit}{Parameter for the initialization of Y. It can be either:
\itemize{ \item a string or a function specifying the initialization
procedure. It should be one of ('random', 'kmeans_lda'). See
\code{\link{benchmarks-functions}} functions for more details. \item A
vector of length N with Q modalities, specifying the initialization
clustering. }}

\item{method}{The clustering algorithm to be used. Only "BBCVEM" is available
: it corresponds to the branch and bound C-VEM of the original article.}

\item{init.beta}{Parameter for the initialization of the matrix beta. It can
be either: \itemize{ \item a string specifying the initialization
procedure. It should be one of ('random', 'lda'). See
\code{\link{initializeBeta}}() for more details. \item A KxV matrix with
each row summing to 1.}}

\item{keep}{The evolution of the bound is tracked every \code{keep} iteration}

\item{max.epochs}{Specifies the maximum number of pass allowed on the whole
dataset.}

\item{verbose}{verbosity level}

\item{nruns}{number of runs of the algorithm (default to 1) : the run
achieving the best evidence lower bound is selected.}

\item{mc.cores}{The number of CPUs to use when fitting in parallel the different
models (only for non-Windows platforms). Default is the number of available
cores minus 1.}
}
\value{
An object of class \code{"\linkS4class{mmpcaClust}"} containing the
  fitted model.
}
\description{
Perform clustering of count data using the MMPCA model.
}
