% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint.R
\name{jointCDF}
\alias{jointCDF}
\alias{posGrid}
\title{Cumulative Joint Distribution}
\usage{
jointCDF(data, grid)

posGrid(nrows, data, grid)
}
\arguments{
\item{data}{The dataset as data.frame class.}

\item{grid}{a data frame with the select rows to include in the grid}

\item{nrows}{Number of rows.}
}
\description{
Functions to compute the multivariate cumulative distribution. It uses a grid data
over the ranges of variables in the dataset to calculate the cumulative values.
}
\details{
\code{jointCDF()} is the main function which uses the internal
function \code{posGrid()}.
}
\examples{
## 1. EXAMPLE
## Dataset with 2 variables
X <- data.frame(rnorm(100), rnorm(100))

## Grid dataset
gridX <- sapply(1:ncol(X), function(i) seq(min(X[,i]), max(X[,i]), length=10))
gridPoints <- expand.grid(gridX) ## expand gridX
ncol(gridPoints)
nrow(gridPoints)

## Joint cumulative values
jointCDF(data = X, grid = gridPoints)

## 2. EXAMPLE
## Dataset with 3 variables
X <- data.frame(rnorm(100), rexp(100), rchisq(100, df=2))

## Grid dataset
gridX <- sapply(1:ncol(X), function(i) seq(min(X[,i]), max(X[,i]), length=10))
gridPoints <- expand.grid(gridX) ## expand gridX
ncol(gridPoints)
nrow(gridPoints)

## Joint cumulative values
jointCDF(data = X, grid = gridPoints)

}
