% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DiscreteLearning.R
\name{goodnessDiscreteVariables}
\alias{goodnessDiscreteVariables}
\alias{getlogLikelihoodDiscreteBN}
\alias{getBICDiscreteBN}
\title{BIC scxore and log-likelihood}
\usage{
getlogLikelihoodDiscreteBN(discreteBN)

getBICDiscreteBN(discreteBN, sameData = FALSE)
}
\arguments{
\item{discreteBN}{A list of multiples lists. Each list contains two entries,
the probabilities and the size of the data which is in each leaf of the discrete tree.}

\item{sameData}{A logical argument; \code{FALSE} means that different datasets were used for learning.}
}
\value{
The loglikelihood and the BIC score of the discrete network.
}
\description{
Compute the loglikelihood and the BIC score for discrete models, i.e multinomial Bayesian Networks.
}
\examples{
## 1. EXAMPLE 
## Discrete data
X <- rep(c("yes", "no", "maybe"), 500)
Y <- rep(c("M", "F"), 750)
data <- data.frame(X=X, Y=Y)
disVar <- c("X","Y")
data <- discreteVariables_as.character(data, discreteVariables=disVar)
n <- nrow(data)

## Probabilities
s <- discreteVariablesStates(namevariables=disVar, discreteData=data)
p <- lapply(1:length(s), function(i) probDiscreteVariable(stateNames=
s[[i]]$states, Variable=data[,i]))

## Log-likelihood
getlogLikelihoodDiscreteBN(p)

## BIC
getBICDiscreteBN(p, sameData = TRUE)

## 2. EXAMPLE 
## Discrete variables
X <- rep(c("1", "2", "3"), 500)
data <- data.frame(X=as.character(X))
s <- discreteVariablesStates(namevariables="X", discreteData=data)
p1 <- probDiscreteVariable(stateNames = s[[1]]$states, Variable = data[,1])

Y <- rep(c("YES", "NO"), 100)
data <- data.frame(Y = as.character(Y))
s <- discreteVariablesStates(namevariables = "Y", discreteData = data)
p2 <- probDiscreteVariable(stateNames = s[[1]]$states, Variable = data[,1])
## Probabilities
P <- list(p1,p2)

## Log-likelihood
getlogLikelihoodDiscreteBN(P)

## BIC
getBICDiscreteBN(P, sameData = TRUE)
}
