% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc.R
\name{auc}
\alias{auc}
\alias{auc.default}
\alias{auc.glm}
\alias{auc.randomForest}
\alias{auc.glmerMod}
\alias{auc.gbm}
\alias{auc.rpart}
\title{Area Under the Curve}
\usage{
auc(...)

\method{auc}{default}(actual, predicted, ...)

\method{auc}{glm}(modelObject, ...)

\method{auc}{randomForest}(modelObject, ...)

\method{auc}{glmerMod}(modelObject, ...)

\method{auc}{gbm}(modelObject, ...)

\method{auc}{rpart}(modelObject, ...)
}
\arguments{
\item{\dots}{additional parameters to be passed the the s3 methods}

\item{actual}{A vector of the labels. Can be \code{numeric, character, or factor}}

\item{predicted}{A vector of predicted values}

\item{modelObject}{the model object. Currently supported \code{glm, randomForest, glmerMod, gbm}}
}
\description{
Calculates the area under the curve for a binary classifcation model
}
\examples{
data(testDF)
glmModel <- glm(y ~ ., data = testDF, family="binomial")
Preds <- predict(glmModel, type = 'response')

auc(testDF$y, Preds)
# using s3 method for glm
auc(glmModel)


}
