% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-shapedescriptors.R
\name{coo_area}
\alias{coo_area}
\title{Calculates the area of a shape}
\usage{
coo_area(coo)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates.}
}
\value{
\code{numeric}, the area.
}
\description{
Calculates the area for a (non-crossing) shape.
}
\note{
Using \code{area.poly} in gpc package is a good idea, but their licence
impedes Momocs to rely on it. but here is the function to do it, once gpc is loaded:
\code{ area.poly(as(coo, 'gpc.poly')) }
}
\examples{
data(bot)
coo_area(bot[1])
# for the distribution of the area of the bottles dataset
hist(sapply(bot$coo, coo_area), breaks=10)
}
\seealso{
Other coo_ descriptors: \code{\link{coo_boundingbox}},
  \code{\link{coo_chull}},
  \code{\link{coo_circularityharalick}},
  \code{\link{coo_circularitynorm}},
  \code{\link{coo_circularity}},
  \code{\link{coo_convexity}},
  \code{\link{coo_eccentricityboundingbox}},
  \code{\link{coo_eccentricityeigen}},
  \code{\link{coo_elongation}}, \code{\link{coo_length}},
  \code{\link{coo_lw}}, \code{\link{coo_rectangularity}},
  \code{\link{coo_rectilinearity}},
  \code{\link{coo_solidity}}, \code{\link{coo_tangle}},
  \code{\link{coo_theta3}}, \code{\link{coo_thetapts}},
  \code{\link{coo_width}}
}

