% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_calliper}
\alias{coo_calliper}
\title{Calculates the calliper length}
\usage{
coo_calliper(coo, arr.ind = FALSE)
}
\arguments{
\item{coo}{a \code{matrix} of (x; y) coordinates.}

\item{arr.ind}{\code{logical}, see below.}
}
\value{
\code{numeric}, the centroid size. If \code{arr.ind=TRUE}, a list with the calliper length \code{$length}
and the two points \code{$arr.ind}. If \code{arr.ind=TRUE}, only the calliper length as a numeric.
}
\description{
Also called the Feret's diameter, the longest distance between two points of
the shape provided.
}
\examples{
b <- bot[1]
coo_calliper(b)
p <- coo_calliper(b, arr.ind=TRUE)
p$length
ids <- p$arr.ind
coo_plot(b)
segments(b[ids[1], 1], b[ids[1], 2], b[ids[2], 1], b[ids[2], 2], lty=2)
}
\seealso{
Other coo_ utilities: \code{\link{coo_aligncalliper}},
  \code{\link{coo_alignminradius}},
  \code{\link{coo_alignxax}}, \code{\link{coo_align}},
  \code{\link{coo_baseline}}, \code{\link{coo_bookstein}},
  \code{\link{coo_boundingbox}},
  \code{\link{coo_centdist}}, \code{\link{coo_center}},
  \code{\link{coo_centpos}}, \code{\link{coo_chull_onion}},
  \code{\link{coo_close}}, \code{\link{coo_down}},
  \code{\link{coo_dxy}}, \code{\link{coo_extract}},
  \code{\link{coo_flipx}}, \code{\link{coo_force2close}},
  \code{\link{coo_interpolate}}, \code{\link{coo_jitter}},
  \code{\link{coo_left}}, \code{\link{coo_nb}},
  \code{\link{coo_perimcum}}, \code{\link{coo_perimpts}},
  \code{\link{coo_perim}}, \code{\link{coo_rev}},
  \code{\link{coo_right}}, \code{\link{coo_rotatecenter}},
  \code{\link{coo_rotate}}, \code{\link{coo_samplerr}},
  \code{\link{coo_sample}}, \code{\link{coo_scalex}},
  \code{\link{coo_scale}}, \code{\link{coo_shearx}},
  \code{\link{coo_slice}},
  \code{\link{coo_slidedirection}},
  \code{\link{coo_slidegap}}, \code{\link{coo_slide}},
  \code{\link{coo_smoothcurve}}, \code{\link{coo_smooth}},
  \code{\link{coo_template}}, \code{\link{coo_trans}},
  \code{\link{coo_trimbottom}}, \code{\link{coo_trimtop}},
  \code{\link{coo_trim}}, \code{\link{coo_up}},
  \code{\link{is_clockwise}}, \code{\link{is_closed}},
  \code{\link{is_equallyspacedradii}}
}
