% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-ldk-procrustes.R
\name{fProcrustes}
\alias{fProcrustes}
\title{Full Procrustes alignment between two shapes}
\usage{
fProcrustes(coo1, coo2)
}
\arguments{
\item{coo1}{configuration matrix to be superimposed onto the centered preshape of coo2.}

\item{coo2}{reference configuration matrix.}
}
\value{
a list with components:
\itemize{
\item \code{coo1} superimposed centered preshape of coo1 onto the centered preshape of coo2
\item \code{coo2} centered preshape of coo2
\item \code{rotation} rotation matrix
\item \code{scale} scale parameter
\item \code{DF} full Procrustes distance between coo1 and coo2.
}
}
\description{
Directly borrowed from Claude (2008), called there the \code{fPsup} function.
}
\references{
Claude, J. (2008). Morphometrics with R. Analysis (p. 316). Springer.
}
\seealso{
Other procrustes functions: \code{\link{fgProcrustes}},
  \code{\link{fgsProcrustes}}, \code{\link{pProcrustes}}
}
