% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-papers.R
\name{papers}
\alias{papers}
\alias{paper}
\alias{paper_white}
\alias{paper_grid}
\alias{paper_chess}
\alias{paper_dots}
\title{grindr papers for shape plots}
\usage{
paper(coo, ...)

paper_white(coo)

paper_grid(coo, grid = c(10, 5), cols = c("#ffa500", "#e5e5e5"), ...)

paper_chess(coo, n = 50, col = "#E5E5E5")

paper_dots(coo, pch = 20, n = 50, col = "#7F7F7F")
}
\arguments{
\item{coo}{a single shape or any \link{Coo} object}

\item{...}{more arguments to feed the plotting function within each \code{paper} function}

\item{grid}{\code{numeric} of length 2 to (roughly) specify the
number of majors lines, and the number of minor lines within two major ones}

\item{cols}{colors (hexadecimal preferred) to use for grid drawing}

\item{n}{\code{numeric} number of squares for the chessboard}

\item{col}{color (hexadecimal) to use for chessboard drawing}

\item{pch}{to use for dots}
}
\description{
Papers on which to use \link{drawers} for building custom
shape plots using the grindr approach. See examples and vignettes.
}
\note{
This approach will (soon) replace \link{coo_plot} and friends in further versions.
All comments are welcome.
}
\seealso{
Other grindr: \code{\link{drawers}}, \code{\link{layers}},
  \code{\link{mosaic_engine}}, \code{\link{pile}},
  \code{\link{plot_PCA}}
}
