% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-ldk-utilities.R
\name{slidings_scheme}
\alias{slidings_scheme}
\title{Extracts partitions of sliding coordinates}
\usage{
slidings_scheme(Coo)
}
\arguments{
\item{Coo}{an Ldk object}
}
\value{
a list with two components: \code{n} the number of partition; \code{id}
their position. Or a NULL if no slidings are defined
}
\description{
Helper function that deduces (likely to be a reminder)
partition scheme from \code{$slidings} of \code{Ldk} objects.
}
\examples{
# no slidings defined a NULL is returned with a message
slidings_scheme(wings)

# slidings defined
slidings_scheme(chaff)

}
\seealso{
Other ldk/slidings methods: \code{\link{add_ldk}},
  \code{\link{def_ldk}}, \code{\link{def_slidings}},
  \code{\link{get_ldk}}, \code{\link{get_slidings}},
  \code{\link{rearrange_ldk}}
}
