% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coo-utilities.R
\name{coo_untiltx}
\alias{coo_untiltx}
\alias{coo_untilt}
\title{Removes rotation so that the centroid and a given point are parallel to the x-axis}
\usage{
coo_untiltx(coo, id, ldk)
}
\arguments{
\item{coo}{\code{matrix} of \verb{(x; y)} coordinates or any \link{Coo} object.}

\item{id}{\code{numeric} the id of the point that will become the new first point. See details below
for the method on Coo objects.}

\item{ldk}{\code{numeric} the id of the ldk to use as id, only on \code{Out}}
}
\value{
a \code{matrix} of (x; y) coordinates, or a \link{Coo} object.
}
\description{
Rotationnal biases appear after \link{coo_slidedirection} (and friends).
Typically useful for outline analysis where phasing matters. See examples.
}
\details{
For Coo objects, and in particular for Out and Opn two different ways of coo_sliding
are available:
\itemize{
\item \strong{no ldk passed and an id is passed}: all id-th points
within the shapes will become the first points.
\item \strong{a single ldk is passed}: the ldk-th ldk will be used to slide every shape.
If an id is (also) passed, id is ignored with a message.
}
}
\examples{
# on a single shape
bot[1] \%>\% coo_center \%>\% coo_align \%>\%
   coo_sample(12) \%>\% coo_slidedirection("right") \%T>\%
   coo_plot() \%>\% # the first point is not on the x-axis
   coo_untiltx() \%>\%
   coo_draw(border="red") # this (red) one is

# on an Out
# prepare bot
prebot <- bot \%>\% coo_center \%>\% coo_scale \%>\%
   coo_align \%>\% coo_slidedirection("right")
prebot \%>\% stack # some dephasing remains
prebot \%>\% coo_slidedirection("right") \%>\% coo_untiltx() \%>\% stack # much better
# _here_ there is no change but the second, untilted, is correct
prebot \%>\% efourier(8, norm=FALSE) \%>\% PCA \%>\% plot_PCA(~type)
prebot \%>\% coo_untiltx \%>\% efourier(8, norm=FALSE) \%>\% PCA \%>\% plot_PCA(~type)

# an example using ldks:
# the landmark #2 is on the x-axis
hearts \%>\%
  slice(1:5) \%>\% fgProcrustes(tol=1e-3) \%>\% # for speed sake
  coo_center \%>\% coo_untiltx(ldk=2) \%>\% stack
}
\seealso{
\link{coo_slide} and friends.

Other coo_ utilities: 
\code{\link{coo_aligncalliper}()},
\code{\link{coo_alignminradius}()},
\code{\link{coo_alignxax}()},
\code{\link{coo_align}()},
\code{\link{coo_baseline}()},
\code{\link{coo_bookstein}()},
\code{\link{coo_boundingbox}()},
\code{\link{coo_calliper}()},
\code{\link{coo_centdist}()},
\code{\link{coo_center}()},
\code{\link{coo_centpos}()},
\code{\link{coo_close}()},
\code{\link{coo_down}()},
\code{\link{coo_dxy}()},
\code{\link{coo_extract}()},
\code{\link{coo_flipx}()},
\code{\link{coo_force2close}()},
\code{\link{coo_interpolate}()},
\code{\link{coo_is_closed}()},
\code{\link{coo_jitter}()},
\code{\link{coo_left}()},
\code{\link{coo_likely_clockwise}()},
\code{\link{coo_nb}()},
\code{\link{coo_perim}()},
\code{\link{coo_range}()},
\code{\link{coo_rev}()},
\code{\link{coo_right}()},
\code{\link{coo_rotatecenter}()},
\code{\link{coo_rotate}()},
\code{\link{coo_sample_prop}()},
\code{\link{coo_samplerr}()},
\code{\link{coo_sample}()},
\code{\link{coo_scale}()},
\code{\link{coo_shearx}()},
\code{\link{coo_slice}()},
\code{\link{coo_slidedirection}()},
\code{\link{coo_slidegap}()},
\code{\link{coo_slide}()},
\code{\link{coo_smoothcurve}()},
\code{\link{coo_smooth}()},
\code{\link{coo_template}()},
\code{\link{coo_trans}()},
\code{\link{coo_trimbottom}()},
\code{\link{coo_trimtop}()},
\code{\link{coo_trim}()},
\code{\link{coo_up}()},
\code{\link{is_equallyspacedradii}()}
}
\concept{coo_ utilities}
