% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-layers.R
\name{plot_LDA}
\alias{plot_LDA}
\title{LDA plot using grindr layers}
\usage{
plot_LDA(
  x,
  axes = c(1, 2),
  palette = pal_qual,
  points = TRUE,
  points_transp = 1/4,
  morphospace = FALSE,
  morphospace_position = "range",
  chull = TRUE,
  chullfilled = FALSE,
  labelgroups = FALSE,
  legend = TRUE,
  title = "",
  center_origin = TRUE,
  zoom = 0.9,
  eigen = TRUE,
  box = TRUE,
  iftwo_layer = layer_histogram_2,
  iftwo_split = FALSE,
  axesnames = TRUE,
  axesvar = TRUE
)
}
\arguments{
\item{x}{\link{LDA} object}

\item{axes}{\code{numeric} of length two to select PCs to use
(\code{c(1, 2)} by default)}

\item{palette}{\code{color palette} to use \code{col_summer} by default}

\item{points}{\code{logical} whether to draw this with \link{layer_points}}

\item{points_transp}{\code{numeric} to feed \link{layer_points} (default:0.25)}

\item{morphospace}{\code{logical} whether to draw this using \link{layer_morphospace_PCA}}

\item{morphospace_position}{to feed \link{layer_morphospace_PCA} (default: "range")}

\item{chull}{\code{logical} whether to draw this with \link{layer_chull}}

\item{chullfilled}{\code{logical} whether to draw this with \link{layer_chullfilled}}

\item{labelgroups}{\code{logical} whether to draw this with \link{layer_labelgroups}}

\item{legend}{\code{logical} whether to draw this with \link{layer_legend}}

\item{title}{\code{character} if specified, fee \link{layer_title} (default to \code{""})}

\item{center_origin}{\code{logical} whether to center origin}

\item{zoom}{\code{numeric} zoom level for the frame (default: 0.9)}

\item{eigen}{\code{logical} whether to draw this using \link{layer_eigen}}

\item{box}{\code{logical} whether to draw this using \link{layer_box}}

\item{iftwo_layer}{function (no quotes) for drawing LD1 when there are two levels.
So far, one of \link{layer_histogram_2} (default) or \link{layer_density_2}}

\item{iftwo_split}{to feed \code{split} argument in \link{layer_histogram_2} or \link{layer_density_2}}

\item{axesnames}{\code{logical} whether to draw this using \link{layer_axesnames}}

\item{axesvar}{\code{logical} whether to draw this using \link{layer_axesvar}}
}
\value{
a plot
}
\description{
Quickly vizualise \link{LDA} objects and build customs plots
using the \link{layers}. See examples.
}
\note{
This approach will replace \link{plot.LDA}.
This is part of \code{grindr} approach that may be packaged at some point. All comments are welcome.
}
\examples{
### First prepare an LDA object

# Some outlines with bot
bl <- bot \%>\%
      # cheap alignement before efourier
      coo_align() \%>\% coo_center \%>\% coo_slidedirection("left") \%>\%
      # add a fake column
      mutate(fake=sample(letters[1:5], 40, replace=TRUE)) \%>\%
      # EFT
      efourier(6, norm=FALSE) \%>\%
      # LDA
      LDA(~fake)

bl \%>\% plot_LDA \%>\% layer_morphospace_LDA

# Below inherited from plot_PCA and to adapt here.
#plot_PCA(bp)
#plot_PCA(bp, ~type)
#plot_PCA(bp, ~fake)

# Some curves with olea
#op <- olea \%>\%
#mutate(s=coo_area(.)) \%>\%
#filter(var != "Cypre") \%>\%
#chop(~view) \%>\% lapply(opoly, 5, nb.pts=90) \%>\%
#combine \%>\% PCA
#op$fac$s \%<>\% as.character() \%>\% as.numeric()

#op \%>\% plot_PCA(title="hi there!")

### Now we can play with layers
# and for instance build a custom plot
# it should start with plot_PCA()

#my_plot <- function(x, ...){

#x \%>\%
#     plot_PCA(...) \%>\%
#    layer_points \%>\%
#     layer_ellipsesaxes \%>\%
#    layer_rug
# }

# and even continue after this function
# op \%>\% my_plot(~var, axes=c(1, 3)) \%>\%
#     layer_title("hi there!") \%>\%
#    layer_stars()

# You get the idea.
}
\seealso{
Other grindr: 
\code{\link{drawers}},
\code{\link{layers_morphospace}},
\code{\link{layers}},
\code{\link{mosaic_engine}()},
\code{\link{papers}},
\code{\link{pile}()},
\code{\link{plot_NMDS}()},
\code{\link{plot_PCA}()}
}
\concept{grindr}
