% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/showPC.r
\name{showPC}
\alias{showPC}
\title{convert PCs to landmark configuration}
\usage{
showPC(scores, PC, mshape)
}
\arguments{
\item{scores}{vector of PC-scores, or matrix with rows containing PC-scores}

\item{PC}{Principal components (eigenvectors of the covariance matrix)
associated with 'scores'.}

\item{mshape}{matrix containing the meanshape's landmarks (used to center
the data by the PCA)}
}
\value{
returns matrix or array containing landmarks
}
\description{
convert PC-scores to landmark coordinates
}
\details{
Rotates and translates PC-scores derived from shape data back into
configuration space.
}
\examples{
library(shapes)
## generate landmarks using
##the first PC-score of the first specimen

proc <- procSym(gorf.dat)
lm <- showPC(proc$PCscores[1,1],proc$PCs[,1],proc$mshape)
plot(lm,asp=1)

##now the first 3 scores
lm2 <- showPC(proc$PCscores[1,1:3],proc$PCs[,1:3],proc$mshape)
points(lm2,col=2)
}
\author{
Stefan Schlager
}
\seealso{
\code{\link{prcomp}}, \code{\link{procSym}}
}

