% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCmeaning.r
\name{getMeaningfulPCs}
\alias{getMeaningfulPCs}
\title{get number of meaningful Principal components}
\usage{
getMeaningfulPCs(values, n, expect = 2, sdev = FALSE)
}
\arguments{
\item{values}{eigenvalues from a PCA}

\item{n}{sample size}

\item{expect}{expectation value for chi-square distribution of df=2}

\item{sdev}{logical: if TRUE, it is assumed that the values are square roots of eigenvalues.}
}
\value{
\item{tol}{threshold of ratio specific for \code{n}}
\item{good}{integer vector specifying the meaningful Principal Components}
}
\description{
get number of meaningful Principal components
}
\details{
This implements the method suggested by Bookstein (2014, pp. 324), to determine whether a PC is entitled to interpretation. I.e. a PC is regarded meaningful (its direction) if the ratio of this PC and its successor is above a threshold based on a log-likelihood ratio (and dependend on sample size).
}
\examples{
data(boneData)
proc <- procSym(boneLM)
getMeaningfulPCs(proc$eigenvalues,n=nrow(proc$PCscores))
## the first 3 PCs are reported as meaningful
## show barplot that seem to fit the bill
barplot(proc$eigenvalues)
}
\references{
Bookstein, F. L. Measuring and reasoning: numerical inference in the sciences. Cambridge University Press, 2014
}
\seealso{
\code{\link{getPCtol}}
}

