% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icpmat.r
\name{icpmat}
\alias{icpmat}
\title{match two landmark configurations using iteratively closest point search}
\usage{
icpmat(x, y, iterations, mindist = 1e+15, subsample = NULL,
  type = c("rigid", "similarity", "affine"), weights = NULL,
  threads = 1, centerweight = FALSE)
}
\arguments{
\item{x}{moving landmarks}

\item{y}{target landmarks}

\item{iterations}{integer: number of iterations}

\item{mindist}{restrict valid points to be within this distance}

\item{subsample}{use a subsample determined by kmean clusters to speed up computation}

\item{type}{character: select the transform to be applied, can be "rigid","similarity" or "affine"}

\item{weights}{vector of length \code{nrow(x)} containing weights for each row in \code{x}}

\item{threads}{integer: number of threads to use.}

\item{centerweight}{logical: if weights are defined and centerweigths=TRUE, the matrix will be centered according to these weights instead of the barycenter.}
}
\value{
returns the rotated landmarks
}
\description{
match two landmark configurations using iteratively closest point search
}
\examples{
data(nose)
icp <- icpmat(shortnose.lm,longnose.lm,iterations=10)

## example using weights
## we want to assign high weights to the first three cordinates
icpw <- icpmat(shortnose.lm,longnose.lm,iterations=10,
               weights=c(rep(100,3),rep(1,620)),centerweight = TRUE)
## the RMSE between those four points and the target is now smaller:
require(Rvcg)
RMSE <- sqrt(sum(vcgKDtree(longnose.lm,icp[1:3,],k=1)$distance^2))
RMSEW<- sqrt(sum(vcgKDtree(longnose.lm,icpw[1:3,],k=1)$distance^2))
barplot(c(RMSE,RMSEW),names.arg=c("RMSE weighted","RMSE unweighted"))
\dontrun{
## plot the differences between unweighted and weighted icp
deformGrid3d(icp,icpw)
## plot the first four coordinates from the icps:
spheres3d(icp[1:3,],col="red",radius = 0.5)
spheres3d(icpw[1:3,],col="green",radius = 0.5)
## plot the target
spheres3d(longnose.lm,col="yellow",radius = 0.2)
}
##2D example  using icpmat to determine point correspondences
if (require(shapes)) {
## we scramble rows to show that this is independent of point order
moving <- gorf.dat[sample(1:8),,1]
plot(moving,asp=1) ## starting config
icpgorf <- icpmat(moving,gorf.dat[,,2],iterations = 20)
points(icpgorf,asp = 1,col=2)
points(gorf.dat[,,2],col=3)## target

## get correspondences using nearest neighbour search
index <- mcNNindex(icpgorf,gorf.dat[,,2],k=1,cores=1)
icpsort <- icpgorf[index,]
for (i in 1:8)
lines(rbind(icpsort[i,],gorf.dat[i,,2]))
}
}
