% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kannisto.R
\name{kannisto.estimate}
\alias{kannisto.estimate}
\title{Kannisto Estimation}
\usage{
kannisto.estimate(mx, ages)
}
\arguments{
\item{mx}{A vector of mortality rates.}

\item{ages}{A vector of ages corresponding to \code{mx}.}
}
\value{
List with the following components:
\describe{
   \item{\code{coefficients}:}{named vector with Kannisto coefficients \eqn{c} and \eqn{d}.}
   \item{\code{fitted.values}:}{the fitted values}
   \item{\code{residuals}:}{input rates minus the fitted values}
}
}
\description{
Estimate the Kannisto parameters (Thatcher et al. 1998).
}
\details{
Given the Kannisto equation \eqn{mlogit(m_x) = \log(c) + dx}{mlogit(mx) = log(c) + dx},
    the function estimates the \eqn{c} and \eqn{d} parameters using 
    values of \code{ages} as the covariate \eqn{x}.
}
\examples{
data(mxM, package = "wpp2017")
mx <- subset(mxM, name == "Canada")[,"2010-2015"]
kannisto.estimate(mx[18:21], ages = 18:21)

}
\references{
Thatcher, A. R., Kannisto, V. and Vaupel, J. W. (1998). The Force of Mortality at Ages 80 to 120, 
volume 5 of Odense Monographs on Population Aging Series. Odense, Denmark: Odense University Press.
}
\seealso{
\code{\link{kannisto.predict}}, \code{\link{kannisto}}, \code{\link{cokannisto.estimate}}
}
