% Generated by roxygen2 (4.0.1): do not edit by hand
\name{showSummaryTable}
\alias{showSummaryTable}
\title{Display summary table of Mplus model statistics in separate window}
\usage{
showSummaryTable(modelList, keepCols, dropCols, sortBy, font = "Courier 9")
}
\arguments{
\item{modelList}{A list of models (as a \code{data.frame}) returned from the \code{extractModelSummaries} function.}

\item{keepCols}{A vector of character strings indicating which columns/variables to display in the summary. Only
columns included in this list will be displayed (all others excluded). By default, \code{keepCols} is:
\code{c("Title", "LL", "Parameters", "AIC", "AICC", "BIC", "RMSEA_Estimate")}.
Example: \code{c("Title", "LL", "AIC", "CFI")}}

\item{dropCols}{A vector of character strings indicating which columns/variables to omit from the summary.
Any column not included in this list will be displayed. By default, \code{dropCols} is \code{NULL}.
Example: \code{c("InputInstructions", "TLI")}}

\item{sortBy}{Optional. Field name (as character string) by which to sort the table.
Typically an information criterion (e.g., \dQuote{AIC} or \dQuote{BIC}) is used to sort the table. Defaults to \dQuote{AICC}.}

\item{font}{Optional. The font to be used to display the summary table. Defaults to Courier 9.}
}
\value{
No value is returned by this function. It is solely used to display the summary table in a separate window.
}
\description{
Displays a summary table of model fit statistics extracted using the \code{extractModelSummaries} function.
This function relies on the \code{showData} function from the relimp package, which displays data in a Tk-based window.
By default, the following summary statistics are included: \code{Title, LL, Parameters, AIC, AICC, BIC, RMSEA_Estimate},
but these are customizable using the \code{keepCols} and \code{dropCols} parameters.
}
\note{
You must choose between \code{keepCols} and \code{dropCols} because
  it is not sensible to use these together to include and exclude columns.
  The function will error if you include both parameters.
}
\examples{
# make me!!!
}
\author{
Michael Hallquist
}
\seealso{
\code{\link{extractModelSummaries}} \code{\link{HTMLSummaryTable}} \code{\link{LatexSummaryTable}}
}
\keyword{interface}

