% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NumOutputs.R
\name{YieldsFitJoint}
\alias{YieldsFitJoint}
\title{Computes two measures of model fit for bond yields}
\usage{
YieldsFitJoint(ModelType, ModelPara, FactorLabels, Economies)
}
\arguments{
\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{ModelPara}{list of model parameter estimates (see the "Optimization" function)}

\item{FactorLabels}{string-list based which contains all the labels of all the variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}
}
\description{
Computes two measures of model fit for bond yields
}
\details{
"Model-implied yields" is the measure of fit based exclusively on the risk-neutral parameters, whereas the
"Model-Fit" takes into account both the risk-neutral and the physical parameters.
}
\references{
See, for instance, Jotiskhatira, Le and Lundblad (2015). "Why do interest rates in different currencies co-move?" (Journal of Financial Economics)
}
\keyword{internal}
