% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastYields.R
\name{ForecastYields}
\alias{ForecastYields}
\title{Generates forecasts of bond yields for all model types}
\usage{
ForecastYields(
  ModelType,
  ModelPara,
  InputsForOutputs,
  FactorLabels,
  Economies,
  JLLlist = NULL,
  GVARlist = NULL,
  WishBRW,
  BRWlist = NULL
)
}
\arguments{
\item{ModelType}{A character vector indicating the model type to be estimated.}

\item{ModelPara}{A list containing the point estimates of the model parameters. For details, refer to the outputs from the \code{\link{Optimization}} function.}

\item{InputsForOutputs}{A list containing the necessary inputs for generating IRFs, GIRFs, FEVDs, GFEVDs and Term Premia.}

\item{FactorLabels}{A list of character vectors with labels for all variables in the model.}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{JLLlist}{A list of necessary inputs for the estimation of JLL-based models (see the \code{\link{JLL}} function).}

\item{GVARlist}{A list containing the necessary inputs for the estimation of GVAR-based models (see the \code{\link{GVAR}} function).}

\item{WishBRW}{Whether to estimate the physical parameter model with bias correction, based on the method by Bauer, Rudebusch and Wu (2012) (see \code{\link{Bias_Correc_VAR}} function). Default is set to 0.}

\item{BRWlist}{List of necessary inputs for performing the bias-corrected estimation (see \code{\link{Bias_Correc_VAR}} function).}
}
\value{
An object of class 'ATSMModelForecast' containing the following elements:
\enumerate{
\item Out-of-sample forecasts of bond yields per forecast horizon
\item Out-of-sample forecast errors of bond yields per forecast horizon
\item Root mean square errors per forecast horizon
}
}
\description{
Generates forecasts of bond yields for all model types
}
\section{Available Methods}{

- `plot(object)`
}

\examples{
# See an example of implementation in the vignette file of this package (Section 4).

}
