% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{BuildRiskFactors_BS}
\alias{BuildRiskFactors_BS}
\title{Build the time-series of the risk factors in each bootstrap draw}
\usage{
BuildRiskFactors_BS(
  ModelParaPE,
  residPdynOriginal,
  residYieOriginal,
  InputsForOutputs,
  Economies,
  ModelType,
  FactorLabels,
  GVARlist,
  JLLlist,
  WishBRW,
  BRWlist,
  nlag = 1,
  verbose
)
}
\arguments{
\item{ModelParaPE}{List of point estimates of the model parameter}

\item{residPdynOriginal}{Time-series of the residuals from the P-dynamics equation (T x F)}

\item{residYieOriginal}{Time-series of the residuals from the observational equation (T x J or T x CJ)}

\item{InputsForOutputs}{List containing the desired inputs for the construction of the numerical outputs.}

\item{Economies}{String-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{Desired model to be estimated}

\item{FactorLabels}{String-list based which contains the labels of all the variables present in the model}

\item{GVARlist}{List of necessary inputs for the estimation of GVAR-based models}

\item{JLLlist}{List of necessary inputs for the estimation of JLL-based models}

\item{WishBRW}{Whether the user wishes to estimate the physical parameter model with the Bias correction model from BRW (2012) (see "Bias_Correc_VAR" function). Default is set to 0.}

\item{BRWlist}{List of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}

\item{nlag}{Number of lags in the P-dynamics. Default is set to 1.}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
Build the time-series of the risk factors in each bootstrap draw
}
\keyword{internal}
