% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{Fitgraphs}
\alias{Fitgraphs}
\title{Model fit graphs for all models}
\usage{
Fitgraphs(
  ModelType,
  WishFitgraphs,
  ModelPara,
  NumOut,
  Economies,
  PathsGraphs,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{A character vector indicating the  estimated model type}

\item{WishFitgraphs}{binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise}

\item{ModelPara}{List of model parameter estimates (See the \code{\link{Optimization}} function)}

\item{NumOut}{A list of outputs containing the model fit, IRFs, FEVDs, GIRFs, GFEVDs and Term premia}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{PathsGraphs}{Path of the folder in which the graphs will be saved}

\item{Folder2save}{Desired folder path to save outputs}

\item{verbose}{Logical flag controlling function messaging}
}
\description{
Model fit graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "Fit")`
}

\examples{
data("ParaSetEx")
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"

Fitgraphs(ModelType, WishFitgraphs = 1, ModelParaEx, NumOutEx, Economy, PathsGraphs = NULL,
          Folder2save = NULL, verbose = FALSE)

}
