% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InputsForOpt.R
\name{GetPdynPara}
\alias{GetPdynPara}
\title{Compute the parameters used in the P-dynamics of the model}
\usage{
GetPdynPara(
  RiskFactors,
  FactorLabels,
  Economies,
  ModelType,
  BRWinputs,
  GVARinputs,
  JLLinputs,
  CheckInputs = F,
  verbose
)
}
\arguments{
\item{RiskFactors}{time series of risk factors (F x T). Could be stored in a list depending on the model}

\item{FactorLabels}{string-list based which contains the labels of all variables present in the model}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{ModelType}{string-vector containing the label of the model to be estimated}

\item{BRWinputs}{list of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}

\item{GVARinputs}{list of necessary inputs for the estimation of GVAR-based models (see "GVAR" function)}

\item{JLLinputs}{list of necessary inputs for the estimation of JLL-based models (see "JLL" function)}

\item{CheckInputs}{Logical. Whether to perform a prior check on the consistency of the provided input list. Default is FALSE.}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
Compute the parameters used in the P-dynamics of the model
}
\keyword{internal}
