% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tradeoff_functions.R
\name{costSkeleton}
\alias{costSkeleton}
\title{Create cost skeleton}
\usage{
costSkeleton(net)
}
\arguments{
\item{net}{the network structure}
}
\value{
the skeleton
}
\description{
Create a more user-friendly data structure to represent the edge
costs in a network.  Internally the network object used by the optmiization
routine represents all the edge costs in a single vector. The "skeleton"
structure decomposes this vector into a list of components, each
corresponding to a different role in the network: "pairings" are edges
between treated and control, exclusion" are direct links between treated
units and a sink that allows them to be excluded, "balance" refers to edges
that count marginal balance between groups, and "sink" indicates edges that
connect control nodes to the sink. Skeletons are created so these various
features can be combined (or switched on and off) easily into objective
functions, and the interface to the main tradeoff function expects to see
each function represented in skeleton format.
}
