/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.mahout.cf.taste.common.TasteException;

public final class PreferenceServlet
extends AbstractMyrrixServlet {
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        float prefValue;
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            userID = Long.parseLong(pathComponents.next());
            itemID = Long.parseLong(pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        try {
            prefValue = PreferenceServlet.readValue(request);
        }
        catch (IllegalArgumentException ignored) {
            response.sendError(400, "Bad value");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            recommender.setPreference(userID, itemID, prefValue);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
    }

    @Override
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            response.sendError(400, "No path");
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            userID = Long.parseLong(pathComponents.next());
            itemID = Long.parseLong(pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            recommender.removePreference(userID, itemID);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + this.getClass().getSimpleName(), te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static float readValue(ServletRequest request) throws IOException {
        String line;
        BufferedReader reader = request.getReader();
        try {
            line = reader.readLine();
        }
        finally {
            Closeables.close(reader, true);
        }
        if (line == null || line.isEmpty()) {
            return 1.0f;
        }
        return LangUtils.parseFloat(line);
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        Iterator<String> pathComponents = SLASH.split(pathInfo).iterator();
        try {
            userID = Long.parseLong(pathComponents.next());
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
        catch (NumberFormatException ignored) {
            return null;
        }
        return userID;
    }
}

