/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PartitionsUtils {
    private static final Logger log = LoggerFactory.getLogger(PartitionsUtils.class);
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern COLON = Pattern.compile(":");

    private PartitionsUtils() {
    }

    public static List<List<HostAndPort>> parseAllPartitions(CharSequence value) {
        if (value == null) {
            return null;
        }
        ArrayList<List<HostAndPort>> allPartitions = Lists.newArrayList();
        for (String partitionString : SEMICOLON.split(value)) {
            ArrayList<HostAndPort> partition = Lists.newArrayList();
            for (String replicaString : COMMA.split(partitionString)) {
                String[] hostPort = COLON.split(replicaString);
                String host = hostPort[0];
                int port = hostPort.length > 1 ? Integer.parseInt(hostPort[1]) : 80;
                Preconditions.checkArgument(port > 0, "port must be positive: %s", port);
                partition.add(HostAndPort.fromParts(host, port));
            }
            Preconditions.checkArgument(!partition.isEmpty(), "At least one partition must be specified");
            allPartitions.add(partition);
        }
        PartitionsUtils.log(allPartitions);
        return allPartitions;
    }

    public static List<List<HostAndPort>> getDefaultLocalPartition(int port) {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        String host = localhost.getHostName();
        return Collections.singletonList(Collections.singletonList(HostAndPort.fromParts(host, port)));
    }

    public static List<List<HostAndPort>> parsePartitionsFromStatus(URL url) throws IOException {
        Document doc;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        InputStreamReader reader = new InputStreamReader(url.openStream(), Charsets.UTF_8);
        try {
            doc = builder.parse(new InputSource(reader));
        }
        catch (SAXException saxe) {
            throw new IllegalStateException(saxe);
        }
        finally {
            Closeables.close(reader, true);
        }
        Element docElement = doc.getDocumentElement();
        docElement.normalize();
        ArrayList<List<HostAndPort>> result = Lists.newArrayList();
        NodeList partitionElements = docElement.getElementsByTagName("partition");
        for (int i = 0; i < partitionElements.getLength(); ++i) {
            ArrayList<HostAndPort> partitionResult = Lists.newArrayList();
            result.add(partitionResult);
            Element partitionElement = (Element)partitionElements.item(i);
            NodeList replicaElements = partitionElement.getElementsByTagName("replica");
            for (int j = 0; j < replicaElements.getLength(); ++j) {
                Node replicaElement = replicaElements.item(j);
                String[] hostPort = COLON.split(replicaElement.getTextContent());
                partitionResult.add(HostAndPort.fromParts(hostPort[0], Integer.parseInt(hostPort[1])));
            }
        }
        return result;
    }

    private static void log(Collection<List<HostAndPort>> allPartitions) {
        if (allPartitions.isEmpty()) {
            log.debug("No partitions parsed");
        } else {
            int partitionNumber = 0;
            for (List<HostAndPort> partition : allPartitions) {
                StringBuilder description = new StringBuilder();
                for (HostAndPort hostPort : partition) {
                    description.append(hostPort).append(' ');
                }
                log.debug("Partition {}: {}", (Object)partitionNumber, (Object)description);
                ++partitionNumber;
            }
        }
    }
}

