/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.knn;

import java.util.Arrays;
import org.apache.mahout.cf.taste.impl.recommender.knn.Optimizer;

public final class ConjugateGradientOptimizer
implements Optimizer {
    private static final double CONVERGENCE_LIMIT = 0.1;
    private static final int MAX_ITERATIONS = 1000;

    @Override
    public double[] optimize(double[][] matrix, double[] b) {
        int k = b.length;
        double[] x = new double[k];
        double[] r = new double[k];
        double[] w = new double[k];
        double[] z = new double[k];
        Arrays.fill(x, 3.0 / (double)k);
        for (int i = 0; i < k; ++i) {
            double ri;
            double v = 0.0;
            double[] ai = matrix[i];
            for (int j = 0; j < k; ++j) {
                v += ai[j] * x[j];
            }
            r[i] = ri = b[i] - v;
            w[i] = -ri;
        }
        for (int iteration = 0; iteration < 1000; ++iteration) {
            for (int i = 0; i < k; ++i) {
                double v = 0.0;
                double[] ai = matrix[i];
                for (int j = 0; j < k; ++j) {
                    v += ai[j] * w[j];
                }
                z[i] = v;
            }
            double anum = 0.0;
            double aden = 0.0;
            for (int i = 0; i < k; ++i) {
                anum += r[i] * w[i];
                aden += w[i] * z[i];
            }
            double a = anum / aden;
            for (int i = 0; i < k; ++i) {
                int n = i;
                x[n] = x[n] + a * w[i];
                int n2 = i;
                r[n2] = r[n2] - a * z[i];
            }
            double rdot = 0.0;
            for (int i = 0; i < k; ++i) {
                double value = r[i];
                rdot += value * value;
            }
            if (rdot <= 0.1) break;
            double bnum = 0.0;
            double bden = 0.0;
            for (int i = 0; i < k; ++i) {
                double zi = z[i];
                bnum += r[i] * zi;
                bden += w[i] * zi;
            }
            double B = bnum / bden;
            for (int i = 0; i < k; ++i) {
                w[i] = -r[i] + B * w[i];
            }
        }
        return x;
    }
}

