/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender.knn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.recommender.knn.Optimizer;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.cf.taste.recommender.CandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.MostSimilarItemsCandidateItemsStrategy;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.common.LongPair;

public final class KnnItemBasedRecommender
extends GenericItemBasedRecommender {
    private static final double BETA = 500.0;
    private final Optimizer optimizer;
    private final int neighborhoodSize;

    public KnnItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, Optimizer optimizer, CandidateItemsStrategy candidateItemsStrategy, MostSimilarItemsCandidateItemsStrategy mostSimilarItemsCandidateItemsStrategy, int neighborhoodSize) {
        super(dataModel, similarity, candidateItemsStrategy, mostSimilarItemsCandidateItemsStrategy);
        this.optimizer = optimizer;
        this.neighborhoodSize = neighborhoodSize;
    }

    public KnnItemBasedRecommender(DataModel dataModel, ItemSimilarity similarity, Optimizer optimizer, int neighborhoodSize) {
        this(dataModel, similarity, optimizer, KnnItemBasedRecommender.getDefaultCandidateItemsStrategy(), KnnItemBasedRecommender.getDefaultMostSimilarItemsCandidateItemsStrategy(), neighborhoodSize);
    }

    private List<RecommendedItem> mostSimilarItems(long itemID, LongPrimitiveIterator possibleItemIDs, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        GenericItemBasedRecommender.MostSimilarEstimator estimator = new GenericItemBasedRecommender.MostSimilarEstimator(itemID, this.getSimilarity(), rescorer);
        return TopItems.getTopItems(howMany, possibleItemIDs, null, estimator);
    }

    private double[] getInterpolations(long itemID, long[] itemNeighborhood, Collection<Long> usersRatedNeighborhood) throws TasteException {
        int length = 0;
        for (int i = 0; i < itemNeighborhood.length; ++i) {
            if (itemNeighborhood[i] != itemID) continue;
            itemNeighborhood[i] = -1L;
            length = itemNeighborhood.length - 1;
            break;
        }
        int k = length;
        double[][] aMatrix = new double[k][k];
        double[] b = new double[k];
        int i = 0;
        DataModel dataModel = this.getDataModel();
        int numUsers = usersRatedNeighborhood.size();
        for (long iitem : itemNeighborhood) {
            if (iitem == -1L) break;
            int j = 0;
            double value = 0.0;
            for (long jitem : itemNeighborhood) {
                if (jitem == -1L) continue;
                for (long user : usersRatedNeighborhood) {
                    float prefVJ = dataModel.getPreferenceValue(user, iitem).floatValue();
                    float prefVK = dataModel.getPreferenceValue(user, jitem).floatValue();
                    value += (double)(prefVJ * prefVK);
                }
                aMatrix[i][j] = value / (double)numUsers;
                ++j;
            }
            ++i;
        }
        i = 0;
        for (long jitem : itemNeighborhood) {
            if (jitem == -1L) break;
            double value = 0.0;
            for (long user : usersRatedNeighborhood) {
                float prefVJ = dataModel.getPreferenceValue(user, jitem).floatValue();
                float prefVI = dataModel.getPreferenceValue(user, itemID).floatValue();
                value += (double)(prefVJ * prefVI);
            }
            b[i] = value / (double)numUsers;
            ++i;
        }
        double avgDiagonal = 0.0;
        if (k > 1) {
            double diagonalA = 0.0;
            for (i = 0; i < k; ++i) {
                diagonalA += aMatrix[i][i];
            }
            double diagonalB = 0.0;
            for (i = k - 1; i >= 0; --i) {
                for (int j = 0; j < k; ++j) {
                    diagonalB += aMatrix[i--][j];
                }
            }
            avgDiagonal = Math.max(diagonalA, diagonalB) / (double)k;
        }
        double avgMatrixA = 0.0;
        double avgVectorB = 0.0;
        for (i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                if (i == j && k > 1) continue;
                avgMatrixA += aMatrix[i][j];
            }
            avgVectorB += b[i];
        }
        if (k > 1) {
            avgMatrixA /= (double)(k * k - k);
        }
        avgVectorB /= (double)k;
        double numUsersPlusBeta = (double)numUsers + 500.0;
        for (i = 0; i < k; ++i) {
            for (int j = 0; j < k; ++j) {
                double average = i == j && k > 1 ? avgDiagonal : avgMatrixA;
                aMatrix[i][j] = ((double)numUsers * aMatrix[i][j] + 500.0 * average) / numUsersPlusBeta;
            }
            b[i] = ((double)numUsers * b[i] + 500.0 * avgVectorB) / numUsersPlusBeta;
        }
        return this.optimizer.optimize(aMatrix, b);
    }

    @Override
    protected float doEstimatePreference(long theUserID, PreferenceArray preferencesFromUser, long itemID) throws TasteException {
        DataModel dataModel = this.getDataModel();
        int size = preferencesFromUser.length();
        FastIDSet possibleItemIDs = new FastIDSet(size);
        for (int i = 0; i < size; ++i) {
            possibleItemIDs.add(preferencesFromUser.getItemID(i));
        }
        possibleItemIDs.remove(itemID);
        List<RecommendedItem> mostSimilar = this.mostSimilarItems(itemID, possibleItemIDs.iterator(), this.neighborhoodSize, null);
        long[] theNeighborhood = new long[mostSimilar.size() + 1];
        theNeighborhood[0] = -1L;
        ArrayList<Long> usersRatedNeighborhood = new ArrayList<Long>();
        int nOffset = 0;
        for (RecommendedItem rec : mostSimilar) {
            theNeighborhood[nOffset++] = rec.getItemID();
        }
        if (!mostSimilar.isEmpty()) {
            theNeighborhood[mostSimilar.size()] = itemID;
            block2: for (int i = 0; i < theNeighborhood.length; ++i) {
                PreferenceArray usersNeighborhood = dataModel.getPreferencesForItem(theNeighborhood[i]);
                int size1 = usersRatedNeighborhood.isEmpty() ? usersNeighborhood.length() : usersRatedNeighborhood.size();
                for (int j = 0; j < size1; ++j) {
                    if (i == 0) {
                        usersRatedNeighborhood.add(usersNeighborhood.getUserID(j));
                        continue;
                    }
                    if (j >= usersRatedNeighborhood.size()) continue block2;
                    long index = (Long)usersRatedNeighborhood.get(j);
                    if (usersNeighborhood.hasPrefWithUserID(index) && index != theUserID) continue;
                    usersRatedNeighborhood.remove(index);
                    --j;
                }
            }
        }
        double[] weights = null;
        if (!mostSimilar.isEmpty()) {
            weights = this.getInterpolations(itemID, theNeighborhood, usersRatedNeighborhood);
        }
        int i = 0;
        double preference = 0.0;
        double totalSimilarity = 0.0;
        for (long jitem : theNeighborhood) {
            Float pref = dataModel.getPreferenceValue(theUserID, jitem);
            if (pref != null) {
                double weight = weights[i];
                preference += (double)pref.floatValue() * weight;
                totalSimilarity += weight;
            }
            ++i;
        }
        return totalSimilarity == 0.0 ? Float.NaN : (float)(preference / totalSimilarity);
    }
}

