% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cen_signedranktest.R
\name{cen_signedranktest}
\alias{cen_signedranktest}
\title{Wilcoxcon Signed-Rank test for censored data}
\usage{
cen_signedranktest(xd, xc, yd, yc, alternative = "two.sided", printstat = TRUE)
}
\arguments{
\item{xd}{The first column of data values plus detection limits}

\item{xc}{The column of censoring indicators for \code{xd}, where 1 (or \code{TRUE}) indicates a detection limit in the xd column, and 0 (or \code{FALSE}) indicates a detected value in xd.}

\item{yd}{The second column of data values plus detection limits, or a single number representing a standard / guideline value.}

\item{yc}{The column of censoring indicators for yd, where 1 (or \code{TRUE}) indicates a detection limit in the yd column, and 0 (or \code{FALSE}) indicates a detected value in \code{yd}. Not needed if \code{yd} is a single standard number.}

\item{alternative}{The usual notation for the alternate hypothesis.  Default is \verb{“two.sided”}.  Options are \verb{“greater”} or \verb{“less”}.}

\item{printstat}{Logical \code{TRUE}/\code{FALSE} option of whether to print the resulting statistics in the console window, or not.  Default is \code{TRUE.}}
}
\value{
Prints a list of Wilcoxon Signed-Rank test with Pratt correction for ties statistics containing the following components:
\itemize{
\item \code{n} Number of samples
\item \code{Z} The value of the test statistic
\item \code{p.value} the p-value of the test
}
}
\description{
Performs a nonparametric Wilcoxon signed-rank test of whether the median difference between two columns of paired censored data equals 0.  Uses the Pratt adjustment for pairs of equal or indistinguishable values.
}
\examples{

data(atrazine)

cen_signedranktest(atrazine$June,atrazine$JuneCen,atrazine$Sept,atrazine$SeptCen)
}
\references{
Helsel, D.R., 2011. Statistics for censored environmental data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.

Page, E.B., 1963. Ordered Hypotheses for Multiple Treatments: A Significance Test for Linear Ranks. Journal of the American Statistical Association 58, 216–230. \doi{https://doi.org/10.2307/2282965}

Pratt, J.W., 1959. Remarks on Zeros and Ties in the Wilcoxon Signed Rank Procedures. Journal of the American Statistical Association 54, 655–667. \doi{https://doi.org/10.2307/2282543}
}
