% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NADA_summary.R
\name{censummary}
\alias{censummary}
\alias{censummary.default}
\alias{censummary.factor}
\alias{censummary.numeric}
\title{Summary Statistics for Censored Data}
\usage{
censummary(obs, censored, groups = NULL, ...)

censummary.default(obs, censored, ...)

censummary.factor(obs, censored, groups, ...)

censummary.numeric(obs, censored, groups, ...)
}
\arguments{
\item{obs}{A numeric vector of observations.}

\item{censored}{A logical vector indicating \code{TRUE} where an observation in \code{obs} is censored (a less-than value), and \code{FALSE} otherwise.}

\item{groups}{Optional grouping variable (factor or numeric) used to compute summaries by subset.}

\item{...}{Additional arguments passed to methods.}
}
\value{
An object of class \code{"censummary"} containing summary statistics,
or a list of such objects if grouped.
}
\description{
Produces basic, and hopefully useful, summary statistics on censored data.
}
\details{
This is a generic function with methods for numeric vectors and grouped data.

The generic function dispatches to methods based on the presence
and type of \code{groups}:
\describe{
\item{\code{censummary.default}}{Basic summary for numeric vectors.}
\item{\code{censummary.factor}}{Summary grouped by a factor variable.}
\item{\code{censummary.numeric}}{Summary grouped by a numeric grouping variable (converted to factor).}
}
}
\references{
Helsel, Dennis R. (2005). \emph{Nondetects and Data Analysis: Statistics for Censored Environmental Data}. John Wiley and Sons, USA, NJ.
}
