% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uMDS.R
\name{uMDS}
\alias{uMDS}
\title{Plot U-score Nonmetric Multidimensional Scaling of censored data}
\usage{
uMDS(uscor, group = NULL, title = NULL, legend.pos = "bottomleft")
}
\arguments{
\item{uscor}{A data frame of uscores or ranks of uscores produced by either the \code{uscores(...)} or \code{uscoresi(...)} functions}

\item{group}{Optional grouping variable. Sites will be represented by different colored symbols for each group.}

\item{title}{Optional title for the NMDS graph.}

\item{legend.pos}{For when group is specified, the location of the legend on the graph showing the colors representing each group’s data.  Default is “bottomleft”.  Alternatives are “topright” and “centerleft”, etc.}
}
\value{
Prints an NMDS plot of censored data groupings based on U-scores
#' @references
Helsel, D.R., 2011. Statistics for Censored Environmental Data using Minitab and R, 2nd ed. John Wiley & Sons, USA, N.J.
}
\description{
Plots an NMDS of uscores output from the \code{uscores} or \code{uscoresi} functions.
}
\examples{
data(PbHeron)

PbHeron.u <- uscores(PbHeron[,4:15])
uMDS(PbHeron.u)

# With group specific
uMDS(PbHeron.u,group=PbHeron$DosageGroup)
}
