% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpVIM_regrImp.R
\name{PipeOpVIM_regrImp}
\alias{PipeOpVIM_regrImp}
\title{PipeOpVIM_regrImp}
\description{
Implements Regression Imputation methods as mlr3 pipeline, more about RI \code{\link{autotune_VIM_regrImp}}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.
}

\section{Parameters}{

The parameters include inherited from [`PipeOpImpute`], as well as: \cr
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"imput_VIM_regrImp"}.
\item \code{robust} :: \code{logical(1)}\cr
TRUE/FALSE: whether to use robust regression, default \code{FALSE}.
\item \code{mod_cat} :: \code{logical(1)}\cr
TRUE/FALSE if TRUE for categorical variables the level with the highest prediction probability is selected, otherwise it is sampled according to the probabilities, default \code{FALSE}.
\item \code{use_imputed} :: \code{logical(1)}\cr
TRUE/FALSe: if TURE, already imputed columns will be used to impute others, default \code{FALSE}.
\item \code{out_fill} :: \code{character(1)}\cr
Output log file location. If file already exists log message will be added. If NULL no log will be produced, default \code{NULL}.
}
}

\examples{
{
  graph <- PipeOpVIM_regrImp$new() \%>>\% mlr3learners::LearnerClassifGlmnet$new()
  graph_learner <- GraphLearner$new(graph)

  # Task with NA

  resample(tsk("pima"), graph_learner, rsmp("cv", folds = 3))
}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpImpute]{mlr3pipelines::PipeOpImpute}} -> \code{VIM_regrImp_imputation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VIM_regrImp_imputation-new}{\code{PipeOpVIM_regrImp$new()}}
\item \href{#method-VIM_regrImp_imputation-clone}{\code{PipeOpVIM_regrImp$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIM_regrImp_imputation-new"></a>}}
\if{latex}{\out{\hypertarget{method-VIM_regrImp_imputation-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpVIM_regrImp$new(
  id = "impute_VIM_regrImp_B",
  robust = FALSE,
  mod_cat = FALSE,
  use_imputed = FALSE,
  out_file = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIM_regrImp_imputation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VIM_regrImp_imputation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpVIM_regrImp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
