% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_lm.R
\name{edge_lm}
\alias{edge_lm}
\title{Edgewise Linear Model}
\usage{
edge_lm(net, nnodes, idata, mod, diag = FALSE, padj,
       cores = NULL, expList = NULL, verbose = TRUE,
       ...)
}
\arguments{
\item{net}{3D volume (2D matrices for each observation) or 2D matrix of edges as columns.}

\item{nnodes}{Number of network nodes.}

\item{idata}{Matrix or data.frame including independent variables of interest of the model.}

\item{mod}{Model, specify as a string, e.g., "~Group + Age".}

\item{diag}{Logical indicating if matrix diagonal is to be included in the analysis (default: FALSE).}

\item{padj}{Character string that indicates the p.adjust method.}

\item{cores}{Number of selected cores for parallel computing (default: NULL).}

\item{expList}{Character string adding variable names to the varlist of 'clusterExport' (default: NULL).}

\item{verbose}{Logical indicating if messages should be printed (default: TRUE).}

\item{...}{Additional arguments to be passed to the low level 'lm' function.}
}
\value{
\emph{data.frame} containing the edge labels, observed statistics,
 their corresponding p-value, and their adjusted p-values.
}
\description{
This function computes the specified linear model (LM) for each edge in the network,
 and calculates the multiple testing p-value based on the p.adjust function.
}
\details{
It's VERY IMPORTANT when giving \emph{net} as a 2D matrix or data.frame, to be
 completely sure that column distribution fits that of the upper triangle indices of an
 \emph{nnodes} * \emph{nnodes} matrix. This may be verified through the edge indices, e.g.,
 "which(upper.tri(matrix(nrow = nnodes, ncol = nnodes)), arr.ind = T)" (see vignette NBR-LME
 for more details).

To know more about \emph{padj} methods, check help for the \code{\link{p.adjust}} function. It is
noticeable that this multiple comparison approach can be much more faster than the permutations run by
the Network-Based Statistics framework, however this is a much more conservative approach
(see Zalesky et al. (2010) \doi{doi:10.1016/j.neuroimage.2010.06.041} for more detail).
}
\examples{
data(frontal2D)
\donttest{
edge_result <- edge_lm(net = frontal2D[,-(1:3)], nnodes = 28,
  idata = frontal2D[,1:3], mod = "~ Group + Sex * Age",
  padj = "fdr")
head(edge_result)
if(any(edge_result[,5]<0.05)){
  show(edge_result[which(edge_result[,5]<0.05),1:5])
}
}

}
